<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://cmsmadesimple.sf.net
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# Marquee Tag 
# (c) 2011 by Olivier LEVILLAIN (olivier.levillain@free.fr)
#  inspired by Status Marquee Tag (c) 2006 by Kerem Gmrkc <netextremecoder@arcor.de>
# Version 1.0

function getUrlByAlias($pagealias) {
  global $gCms;
  $hm =& $gCms->GetHierarchyManager();
  $curnode =& $hm->getNodeByAlias($pagealias);
  if ($curnode == null) die ("marquee tag: page not found for alias $pagealias");
  $curcontent =& $curnode->GetContent();
  return $curcontent->GetURL();
}

function smarty_cms_function_marquee($params, &$smarty) {
    //javascript window objects name property, will be taken as the animation text
	$text = (empty($params['text'])? 'marquee not defined' : $params['text']); 
	//the animation speed in milliseconds, that is the speed for the char by char animation, default is 100 and should be good enough
    $speed = (empty($params['speed'])? "200" : $params['speed']); 
    // surrounding text - optionnal
	$extension_text = (empty($params['extension_text'])? "               " : $params['extension_text']);
	$text = $extension_text.$text.$extension_text;
	//the optional internal link of the marquee
    $link = (empty($params['link_alias'])? "" : "onclick=\"window.location.assign('".getUrlByAlias($params['link_alias'])."')\" onmouseover=\"style.cursor='pointer'\" "); 
    $marquee_name = (empty($params['name'])? "default" : $params['name']); 
	$marquee_var = $marquee_name.'Marquee';
	$marquee_func = $marquee_name.'ScrollMarquee';
    //the complete output from the tag itself
	$marquee_code = <<<SMC
	<button class="marquee" id="{$marquee_var}" {$link}> </button>
<script type="text/javascript">
    var {$marquee_var} = "{$text}";
	function {$marquee_func}(){
		//roll first char to last char
		{$marquee_var} = {$marquee_var}.slice(1) + {$marquee_var}.charAt(0,1);
		document.getElementById("{$marquee_var}").innerHTML = {$marquee_var}.replace(/ /gi, "&nbsp;");
		setTimeout ("{$marquee_func}()",{$speed});
	}
	{$marquee_func}(); // starts scrolling
</script>
SMC;
	return $marquee_code;    
}

function smarty_cms_help_function_marquee() {
	?>
	<h3>What does this do?</h3>
	<p>This tag is used to create a moving text in your page like<br>the <span style="color:green;">&lt;MARQUEE&gt;</span> tag does inside IE.</p>
	<p>Example:</p>
	<p><marquee style="border:1px solid gray;" width="200">+++++++++This is my Marquee+++++++++</marquee></p>
	<h3>How do I use it?</h3>
	<p>Just insert this <code>{marquee text="+++++++++This is my Marquee+++++++++"}</code> inside a page.<br> 
		Replace the &quot;text&quot; parameters value with your own text. <br>
    <h3>What parameters does it take?</h3>
	<p>Parameters are:
	<ul>
		<li>(mandatory) <span style="color:blue;">text=&quot;Some Text&quot;</span> - This is the text that will be animated(scrolled) in the page. Default is "marquee not defined".</li>
		<li>(optional) <span style="color:blue;">extension_text=&quot;Some Extension Text&quot;</span> - This is the text that will be added to the beginning and at the end of the scrolling text.<br>
		Most of the time you will use whitespaces to create some extra scrolling space.</li>
		<li>(optional) <span style="color:blue;">speed=&quot;millisecs&quot;</span> - This is the time in milliseconds the text will be animated(scrolled) char by char. Default is 200 milliseconds.</li>
		<li>(optional) <span style="color:blue;">link_alias=&quot;a-page-alias&quot;</span> - This is the alias of a page where you will be redirected when the marquee is clicked. Default is none.</li>
		<li>(optional) <span style="color:blue;">name=&quot;default&quot;</span> - This is the name of the marquee. It is mandatory if you want to put several marquees on the same page. They must all have different names.</li>
	</ul>
	</p>
	<p>you can define your css style for the class named "marquee" of for the id named {name}Marquee (i.e. defaultMarquee by default)</p>
	<p>Please note that the tag is generated as a &lt;button&gt; HTML tag</p>
	<p>An example of basic css code is :
	<code>
	.defaultMarquee {
		width:80%;
		height:60px;
		font-size:1.2em;
	}
	</code>
	</p>
  <h3>Tested on:</h3>
	 <ul>
	  <li>Internet Explorer 9</li>
	  <li>Mozilla Firefox 4 (Windows)</li>
	  <li>Google Chrome 11</li>
	 </ul>	
	<?php
}

function smarty_cms_about_function_marquee() {
	?>
	<p>Author: Olivier LEVILLAIN (olivier daht levillain aht free.fr)</p>
	<p>Version: 1.0</p>
	<p>
	Change History:<br/>
	None
	</p>
	<?php
}

?>
